/*
 * Decompiled with CFR 0.152.
 */
package WebseitenPfadGenerator;

import WebseitenPfadGenerator.FileScanner;
import WebseitenPfadGenerator.FileTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PathGeneratorApp
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField directoryPathField;
    private JButton selectDirectoryButton;
    private JTree startTree;
    private JTree targetTree;
    private JButton generatePathButton;
    private JTextArea resultTextArea;
    private JButton copyPathButton;
    private JButton refreshButton;
    private JButton collapseStartTreeButton;
    private JButton collapseTargetTreeButton;
    private JPanel filterPanel;
    private List<JCheckBox> extensionCheckBoxes;
    private JTextField startSearchField;
    private JButton startSearchButton;
    private JTextField targetSearchField;
    private JButton targetSearchButton;
    private File currentRootDirectory;
    private Preferences prefs;
    private DefaultMutableTreeNode startTreeRoot;
    private DefaultMutableTreeNode targetTreeRoot;
    private List<String> allTargetPathsUnfiltered;
    private List<String> allStartHtmlPathsUnfiltered;

    public PathGeneratorApp() {
        super("Webseiten-Pfad-Generator");
        this.setDefaultCloseOperation(3);
        this.setSize(1200, 700);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout(10, 10));
        this.prefs = Preferences.userNodeForPackage(PathGeneratorApp.class);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PathGeneratorApp.this.saveExpandedTreeStates();
            }
        });
        JPanel directoryPanel = new JPanel(new FlowLayout(0, 10, 5));
        directoryPanel.setBorder(BorderFactory.createTitledBorder("Projektverzeichnis ausw\u00e4hlen"));
        this.directoryPathField = new JTextField(50);
        this.directoryPathField.setEditable(false);
        this.directoryPathField.setText("Bitte ein Verzeichnis ausw\u00e4hlen...");
        directoryPanel.add(this.directoryPathField);
        this.selectDirectoryButton = new JButton("Verzeichnis ausw\u00e4hlen...");
        directoryPanel.add(this.selectDirectoryButton);
        this.add((Component)directoryPanel, "North");
        JPanel treeSelectionPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        treeSelectionPanel.setBorder(BorderFactory.createTitledBorder("Start- und Zieldatei ausw\u00e4hlen"));
        JPanel startTreePanel = new JPanel(new BorderLayout(5, 5));
        JPanel startHeaderPanel = new JPanel(new BorderLayout());
        startHeaderPanel.add((Component)new JLabel("Startseite / Ausgangsdatei:"), "West");
        JPanel startSearchPanel = new JPanel(new FlowLayout(2, 5, 0));
        this.startSearchField = new JTextField(15);
        this.startSearchField.setToolTipText("Dateinamen suchen (Gro\u00df-/Kleinschreibung ignorieren)");
        this.startSearchButton = new JButton("Suchen");
        startSearchPanel.add(this.startSearchField);
        startSearchPanel.add(this.startSearchButton);
        startHeaderPanel.add((Component)startSearchPanel, "Center");
        this.collapseStartTreeButton = new JButton("Alle einklappen");
        startHeaderPanel.add((Component)this.collapseStartTreeButton, "East");
        startTreePanel.add((Component)startHeaderPanel, "North");
        this.startTreeRoot = new DefaultMutableTreeNode("Projektordner (leer)");
        this.startTree = new JTree(new DefaultTreeModel(this.startTreeRoot));
        this.startTree.getSelectionModel().setSelectionMode(1);
        this.startTree.setRootVisible(true);
        this.startTree.setCellRenderer(new FileTreeCellRenderer());
        startTreePanel.add((Component)new JScrollPane(this.startTree), "Center");
        treeSelectionPanel.add(startTreePanel);
        JPanel targetTreePanel = new JPanel(new BorderLayout(5, 5));
        JPanel targetHeaderPanel = new JPanel(new BorderLayout());
        targetHeaderPanel.add((Component)new JLabel("Zielseite / Zieldatei:"), "West");
        JPanel targetSearchPanel = new JPanel(new FlowLayout(2, 5, 0));
        this.targetSearchField = new JTextField(15);
        this.targetSearchField.setToolTipText("Dateinamen suchen (Gro\u00df-/Kleinschreibung ignorieren)");
        this.targetSearchButton = new JButton("Suchen");
        targetSearchPanel.add(this.targetSearchField);
        targetSearchPanel.add(this.targetSearchButton);
        targetHeaderPanel.add((Component)targetSearchPanel, "Center");
        this.collapseTargetTreeButton = new JButton("Alle einklappen");
        targetHeaderPanel.add((Component)this.collapseTargetTreeButton, "East");
        targetTreePanel.add((Component)targetHeaderPanel, "North");
        this.targetTreeRoot = new DefaultMutableTreeNode("Projektordner (leer)");
        this.targetTree = new JTree(new DefaultTreeModel(this.targetTreeRoot));
        this.targetTree.getSelectionModel().setSelectionMode(1);
        this.targetTree.setRootVisible(true);
        this.targetTree.setCellRenderer(new FileTreeCellRenderer());
        targetTreePanel.add((Component)new JScrollPane(this.targetTree), "Center");
        this.filterPanel = new JPanel(new FlowLayout(0, 5, 2));
        this.filterPanel.setBorder(BorderFactory.createTitledBorder("Dateitypen filtern"));
        targetTreePanel.add((Component)this.filterPanel, "South");
        treeSelectionPanel.add(targetTreePanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 20, 5));
        this.generatePathButton = new JButton("Pfad generieren");
        buttonPanel.add(this.generatePathButton);
        this.refreshButton = new JButton("Aktualisieren");
        buttonPanel.add(this.refreshButton);
        JPanel mainContentPanel = new JPanel(new BorderLayout(10, 10));
        mainContentPanel.add((Component)treeSelectionPanel, "Center");
        mainContentPanel.add((Component)buttonPanel, "South");
        this.add((Component)mainContentPanel, "Center");
        JPanel resultPanel = new JPanel(new BorderLayout(10, 10));
        resultPanel.setBorder(BorderFactory.createTitledBorder("Generierter Pfad"));
        this.resultTextArea = new JTextArea(5, 50);
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setLineWrap(true);
        this.resultTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.resultTextArea);
        resultPanel.add((Component)scrollPane, "Center");
        this.copyPathButton = new JButton("Pfad kopieren");
        resultPanel.add((Component)this.copyPathButton, "East");
        this.add((Component)resultPanel, "South");
        this.addEventListeners();
        String lastPath = this.prefs.get("lastProjectPath", null);
        if (lastPath != null && !lastPath.isEmpty()) {
            File lastDirectory = new File(lastPath);
            if (lastDirectory.isDirectory() && lastDirectory.exists()) {
                this.currentRootDirectory = lastDirectory;
                this.directoryPathField.setText(this.currentRootDirectory.getAbsolutePath());
                this.populateTreesAndFilters(this.currentRootDirectory);
            } else {
                JOptionPane.showMessageDialog(this, "Der zuletzt gespeicherte Projektpfad existiert nicht mehr oder ist ung\u00fcltig.\nBitte w\u00e4hlen Sie ein neues Verzeichnis aus.", "Gespeicherter Pfad ung\u00fcltig", 2);
                this.directoryPathField.setText("Bitte ein Verzeichnis ausw\u00e4hlen...");
            }
        } else {
            this.directoryPathField.setText("Bitte ein Verzeichnis ausw\u00e4hlen...");
        }
        this.setVisible(true);
    }

    private void addEventListeners() {
        this.selectDirectoryButton.addActionListener(e -> {
            int option;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            if (this.currentRootDirectory != null && this.currentRootDirectory.exists()) {
                fileChooser.setCurrentDirectory(this.currentRootDirectory);
                this.saveExpandedTreeStates();
            }
            if ((option = fileChooser.showOpenDialog(this)) == 0) {
                this.currentRootDirectory = fileChooser.getSelectedFile();
                this.directoryPathField.setText(this.currentRootDirectory.getAbsolutePath());
                this.populateTreesAndFilters(this.currentRootDirectory);
                this.prefs.put("lastProjectPath", this.currentRootDirectory.getAbsolutePath());
            }
        });
        this.generatePathButton.addActionListener(e -> this.generateRelativePath());
        this.copyPathButton.addActionListener(e -> {
            String path = this.resultTextArea.getText();
            if (path != null && !path.isEmpty()) {
                StringSelection stringSelection = new StringSelection(path);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                JOptionPane.showMessageDialog(this, "Pfad in die Zwischenablage kopiert!");
            }
        });
        this.startTree.addTreeSelectionListener(e -> this.generateRelativePath());
        this.targetTree.addTreeSelectionListener(e -> this.generateRelativePath());
        this.refreshButton.addActionListener(e -> {
            if (this.currentRootDirectory != null && this.currentRootDirectory.exists()) {
                this.saveExpandedTreeStates();
                this.populateTreesAndFilters(this.currentRootDirectory);
                JOptionPane.showMessageDialog(this, "Die Verzeichnisstruktur wurde aktualisiert.", "Aktualisiert", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Bitte w\u00e4hlen Sie zuerst ein Projektverzeichnis aus, um es zu aktualisieren.", "Kein Verzeichnis ausgew\u00e4hlt", 2);
            }
        });
        this.collapseStartTreeButton.addActionListener(e -> {
            int row = this.startTree.getRowCount() - 1;
            while (row >= 0) {
                this.startTree.collapseRow(row);
                --row;
            }
            this.startTree.expandPath(new TreePath(this.startTreeRoot));
            this.prefs.put("startTreeExpandedPaths_" + this.generateMd5Hash(this.currentRootDirectory.getAbsolutePath()), "");
        });
        this.collapseTargetTreeButton.addActionListener(e -> {
            int row = this.targetTree.getRowCount() - 1;
            while (row >= 0) {
                this.targetTree.collapseRow(row);
                --row;
            }
            this.targetTree.expandPath(new TreePath(this.targetTreeRoot));
            this.prefs.put("targetTreeExpandedPaths_" + this.generateMd5Hash(this.currentRootDirectory.getAbsolutePath()), "");
        });
        this.startSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PathGeneratorApp.this.performSearch(PathGeneratorApp.this.startTree, PathGeneratorApp.this.startTreeRoot, PathGeneratorApp.this.startSearchField.getText(), PathGeneratorApp.this.allStartHtmlPathsUnfiltered, true);
                }
            }
        });
        this.startSearchButton.addActionListener(e -> this.performSearch(this.startTree, this.startTreeRoot, this.startSearchField.getText(), this.allStartHtmlPathsUnfiltered, true));
        this.targetSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PathGeneratorApp.this.performSearch(PathGeneratorApp.this.targetTree, PathGeneratorApp.this.targetTreeRoot, PathGeneratorApp.this.targetSearchField.getText(), PathGeneratorApp.this.allTargetPathsUnfiltered, false);
                }
            }
        });
        this.targetSearchButton.addActionListener(e -> this.performSearch(this.targetTree, this.targetTreeRoot, this.targetSearchField.getText(), this.allTargetPathsUnfiltered, false));
    }

    private void populateTreesAndFilters(File directory) {
        this.startTreeRoot.removeAllChildren();
        this.targetTreeRoot.removeAllChildren();
        if (directory == null || !directory.isDirectory() || !directory.exists()) {
            this.updateFilterCheckboxes(null);
            JOptionPane.showMessageDialog(this, "Der angegebene Pfad ist kein g\u00fcltiges Verzeichnis oder existiert nicht.", "Fehlerhaftes Verzeichnis", 0);
            return;
        }
        FileScanner scanner = new FileScanner();
        this.allStartHtmlPathsUnfiltered = scanner.scanForHtmlFiles(directory);
        this.startTreeRoot.setUserObject(directory);
        this.buildTree(directory, this.allStartHtmlPathsUnfiltered, this.startTreeRoot, true);
        ((DefaultTreeModel)this.startTree.getModel()).reload();
        this.allTargetPathsUnfiltered = scanner.scanDirectory(directory);
        this.targetTreeRoot.setUserObject(directory);
        this.buildTree(directory, this.allTargetPathsUnfiltered, this.targetTreeRoot, false);
        ((DefaultTreeModel)this.targetTree.getModel()).reload();
        this.updateFilterCheckboxes(directory);
        this.populateTargetTreeFiltered();
        if (this.startTreeRoot.getChildCount() > 0) {
            this.startTree.setSelectionPath(new TreePath(this.startTreeRoot.getFirstChild()));
        } else {
            JOptionPane.showMessageDialog(this, "Keine HTML-Dateien im ausgew\u00e4hlten Verzeichnis gefunden.\nDie Startauswahl ist leer.", "Keine HTML-Dateien", 1);
            this.resultTextArea.setText("W\u00e4hlen Sie ein Verzeichnis mit HTML-Dateien aus.");
        }
        this.loadExpandedTreeStates(directory);
    }

    private void buildTree(File currentFile, List<String> allowedPaths, DefaultMutableTreeNode parentNode, boolean isHtmlTree) {
        if (!currentFile.isDirectory()) {
            return;
        }
        File[] children = currentFile.listFiles();
        if (children == null) {
            return;
        }
        ArrayList<File> sortedChildren = new ArrayList<File>(Arrays.asList(children));
        sortedChildren.sort((f1, f2) -> {
            if (f1.isDirectory() && !f2.isDirectory()) {
                return -1;
            }
            if (!f1.isDirectory() && f2.isDirectory()) {
                return 1;
            }
            return f1.getName().compareToIgnoreCase(f2.getName());
        });
        for (File child : sortedChildren) {
            boolean shouldAdd = false;
            if (child.isDirectory()) {
                shouldAdd = true;
            } else if (child.isFile()) {
                if (isHtmlTree) {
                    if (child.getName().toLowerCase().endsWith(".html")) {
                        shouldAdd = true;
                    }
                } else if (allowedPaths.contains(child.getAbsolutePath())) {
                    shouldAdd = true;
                }
            }
            if (!shouldAdd) continue;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child.getName());
            childNode.setUserObject(child);
            if (child.isDirectory()) {
                boolean hasAllowedChildren = this.hasAllowedChildren(child, allowedPaths, isHtmlTree);
                if (!hasAllowedChildren) continue;
                parentNode.add(childNode);
                this.buildTree(child, allowedPaths, childNode, isHtmlTree);
                continue;
            }
            parentNode.add(childNode);
        }
    }

    private boolean hasAllowedChildren(File directory, List<String> allowedPaths, boolean isHtmlTree) {
        if (!directory.isDirectory()) {
            return false;
        }
        File[] children = directory.listFiles();
        if (children == null) {
            return false;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile() ? (isHtmlTree ? child.getName().toLowerCase().endsWith(".html") && allowedPaths.contains(child.getAbsolutePath()) : allowedPaths.contains(child.getAbsolutePath())) : child.isDirectory() && this.hasAllowedChildren(child, allowedPaths, isHtmlTree)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void expandTree(JTree tree, TreePath parent) {
        if (parent == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandTree(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void updateFilterCheckboxes(File directory) {
        this.filterPanel.removeAll();
        this.extensionCheckBoxes = new ArrayList<JCheckBox>();
        if (directory == null) {
            this.filterPanel.revalidate();
            this.filterPanel.repaint();
            return;
        }
        FileScanner scanner = new FileScanner();
        Set<String> uniqueExtensions = scanner.getAllUniqueFileExtensions(directory);
        JCheckBox allFilesCheckBox = new JCheckBox("Alle Dateien");
        allFilesCheckBox.setSelected(true);
        allFilesCheckBox.addActionListener(e -> {
            if (allFilesCheckBox.isSelected()) {
                for (JCheckBox cb : this.extensionCheckBoxes) {
                    if (cb == allFilesCheckBox) continue;
                    cb.setSelected(false);
                }
            }
            this.populateTargetTreeFiltered();
        });
        this.filterPanel.add(allFilesCheckBox);
        this.extensionCheckBoxes.add(allFilesCheckBox);
        for (String ext : uniqueExtensions) {
            JCheckBox cb = new JCheckBox("." + ext);
            cb.addActionListener(e -> {
                if (cb.isSelected()) {
                    allFilesCheckBox.setSelected(false);
                } else {
                    boolean anySpecificSelected = false;
                    for (JCheckBox otherCb : this.extensionCheckBoxes) {
                        if (otherCb == allFilesCheckBox || !otherCb.isSelected()) continue;
                        anySpecificSelected = true;
                        break;
                    }
                    if (!anySpecificSelected) {
                        allFilesCheckBox.setSelected(true);
                    }
                }
                this.populateTargetTreeFiltered();
            });
            this.filterPanel.add(cb);
            this.extensionCheckBoxes.add(cb);
        }
        this.filterPanel.revalidate();
        this.filterPanel.repaint();
    }

    private void populateTargetTreeFiltered() {
        this.populateTreeFilteredInternal(this.targetTree, this.targetTreeRoot, this.allTargetPathsUnfiltered, false, this.targetSearchField.getText());
    }

    private void populateStartTreeFiltered() {
        this.populateTreeFilteredInternal(this.startTree, this.startTreeRoot, this.allStartHtmlPathsUnfiltered, true, this.startSearchField.getText());
    }

    private void populateTreeFilteredInternal(JTree tree, DefaultMutableTreeNode rootNode, List<String> unfilteredPaths, boolean isHtmlTree, String searchTerm) {
        rootNode.removeAllChildren();
        if (this.currentRootDirectory == null || unfilteredPaths == null || unfilteredPaths.isEmpty()) {
            ((DefaultTreeModel)tree.getModel()).reload();
            return;
        }
        HashSet<String> selectedExtensions = new HashSet<String>();
        boolean allFilesCheckboxIsCurrentlySelected = false;
        boolean anySpecificFilterIsCurrentlySelected = false;
        if (!isHtmlTree) {
            for (JCheckBox cb : this.extensionCheckBoxes) {
                if (cb.getText().equals("Alle Dateien")) {
                    if (!cb.isSelected()) continue;
                    allFilesCheckboxIsCurrentlySelected = true;
                    continue;
                }
                if (!cb.isSelected()) continue;
                selectedExtensions.add(cb.getText().substring(1));
                anySpecificFilterIsCurrentlySelected = true;
            }
            if (!anySpecificFilterIsCurrentlySelected && !allFilesCheckboxIsCurrentlySelected) {
                for (JCheckBox cb : this.extensionCheckBoxes) {
                    if (!cb.getText().equals("Alle Dateien")) continue;
                    cb.setSelected(true);
                    allFilesCheckboxIsCurrentlySelected = true;
                    break;
                }
            }
        } else {
            allFilesCheckboxIsCurrentlySelected = true;
        }
        boolean shouldExpandAutomatically = isHtmlTree ? !searchTerm.trim().isEmpty() : anySpecificFilterIsCurrentlySelected || !searchTerm.trim().isEmpty();
        ArrayList<String> pathsToShow = new ArrayList<String>();
        HashSet<String> pathsToExpand = new HashSet<String>();
        String lowerCaseSearchTerm = searchTerm.toLowerCase().trim();
        for (String absolutePath : unfilteredPaths) {
            boolean fileMatchesSearch;
            File file = new File(absolutePath);
            if (file.isDirectory()) {
                pathsToShow.add(absolutePath);
                if (!shouldExpandAutomatically || !file.getName().toLowerCase().contains(lowerCaseSearchTerm)) continue;
                try {
                    pathsToExpand.add(file.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Fehler beim Abrufen des kanonischen Pfads f\u00fcr Expandierung: " + e.getMessage());
                }
                continue;
            }
            if (!file.isFile()) continue;
            String fileName = file.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String fileExtension = "";
            if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
                fileExtension = fileName.substring(dotIndex + 1).toLowerCase();
            }
            boolean fileMatchesFilter = false;
            fileMatchesFilter = isHtmlTree ? fileName.toLowerCase().endsWith(".html") : allFilesCheckboxIsCurrentlySelected && !anySpecificFilterIsCurrentlySelected || anySpecificFilterIsCurrentlySelected && selectedExtensions.contains(fileExtension) || fileExtension.isEmpty() && allFilesCheckboxIsCurrentlySelected;
            boolean bl = fileMatchesSearch = lowerCaseSearchTerm.isEmpty() || fileName.toLowerCase().contains(lowerCaseSearchTerm);
            if (!fileMatchesFilter || !fileMatchesSearch) continue;
            pathsToShow.add(absolutePath);
            if (!shouldExpandAutomatically) continue;
            File parent = file.getParentFile();
            while (parent != null && !parent.equals(this.currentRootDirectory.getParentFile())) {
                try {
                    pathsToExpand.add(parent.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Fehler beim Abrufen des kanonischen Pfads f\u00fcr Expandierung: " + e.getMessage());
                }
                parent = parent.getParentFile();
            }
        }
        rootNode.setUserObject(this.currentRootDirectory);
        this.buildTree(this.currentRootDirectory, pathsToShow, rootNode, isHtmlTree);
        ((DefaultTreeModel)tree.getModel()).reload();
        if (rootNode.getChildCount() > 0) {
            tree.setSelectionPath(new TreePath(rootNode.getFirstChild()));
        }
        if (shouldExpandAutomatically) {
            this.applyExpandedPaths(tree, rootNode, new ArrayList<String>(pathsToExpand));
        } else {
            int row = tree.getRowCount() - 1;
            while (row >= 0) {
                tree.collapseRow(row);
                --row;
            }
            tree.expandPath(new TreePath(rootNode));
        }
    }

    private void generateRelativePath() {
        DefaultMutableTreeNode selectedNode;
        Object userObject;
        TreePath targetPath;
        DefaultMutableTreeNode selectedNode2;
        Object userObject2;
        File startFileSelected = null;
        File targetFileSelected = null;
        TreePath startPath = this.startTree.getSelectionPath();
        if (startPath != null && (userObject2 = (selectedNode2 = (DefaultMutableTreeNode)startPath.getLastPathComponent()).getUserObject()) instanceof File) {
            startFileSelected = (File)userObject2;
        }
        if ((targetPath = this.targetTree.getSelectionPath()) != null && (userObject = (selectedNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent()).getUserObject()) instanceof File) {
            targetFileSelected = (File)userObject;
        }
        if (this.currentRootDirectory == null || startFileSelected == null || targetFileSelected == null) {
            this.resultTextArea.setText("W\u00e4hlen Sie Start- und Zieldatei im Baum aus.");
            return;
        }
        File baseFileForPathCalculation = startFileSelected.isFile() ? startFileSelected.getParentFile() : startFileSelected;
        if (baseFileForPathCalculation == null) {
            this.resultTextArea.setText("Fehler: Ung\u00fcltiger Startpunkt f\u00fcr Pfadberechnung.");
            return;
        }
        String relativePath = this.getRelativePath(baseFileForPathCalculation, targetFileSelected);
        this.resultTextArea.setText(relativePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRelativePath(File baseFile, File targetFile) {
        try {
            String basePath = baseFile.getCanonicalPath();
            String targetPath = targetFile.getCanonicalPath();
            String[] baseParts = basePath.split(File.separator.replace("\\", "\\\\"));
            String[] targetParts = targetPath.split(File.separator.replace("\\", "\\\\"));
            StringBuilder relativePath = new StringBuilder();
            int commonPrefixLength = 0;
            while (commonPrefixLength < baseParts.length && commonPrefixLength < targetParts.length && baseParts[commonPrefixLength].equals(targetParts[commonPrefixLength])) {
                ++commonPrefixLength;
            }
            int i = commonPrefixLength;
            while (i < baseParts.length) {
                relativePath.append("..").append("/");
                ++i;
            }
            i = commonPrefixLength;
            while (i < targetParts.length) {
                relativePath.append(targetParts[i]).append("/");
                ++i;
            }
            String finalPath = relativePath.toString();
            if (basePath.equals(targetPath)) {
                if (targetFile.isDirectory()) {
                    return "./";
                }
                return targetFile.getName();
            }
            if (targetFile.isFile() && finalPath.endsWith("/")) {
                finalPath = finalPath.substring(0, finalPath.length() - 1);
            }
            if (finalPath.isEmpty()) {
                if (targetFile.isFile()) {
                    return targetFile.getName();
                }
                if (targetFile.isDirectory()) {
                    return "./";
                }
            }
            return finalPath.replace("\\", "/");
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Ein unerwarteter Fehler ist bei der Pfadberechnung aufgetreten:\n" + e.getMessage(), "Fehler bei Pfadberechnung", 0);
            return "FEHLER BEI PFADBERECHNUNG";
        }
    }

    private List<String> getExpandedPaths(JTree tree) {
        ArrayList<String> expandedPaths = new ArrayList<String>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreePath> expanded = tree.getExpandedDescendants(new TreePath(root));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                File file;
                TreePath path = expanded.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof File) || !(file = (File)userObject).isDirectory()) continue;
                try {
                    expandedPaths.add(file.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Fehler beim Abrufen des kanonischen Pfads: " + e.getMessage());
                }
            }
        }
        return expandedPaths;
    }

    private void saveExpandedTreeStates() {
        if (this.currentRootDirectory == null) {
            return;
        }
        String projectPathHash = this.generateMd5Hash(this.currentRootDirectory.getAbsolutePath());
        if (projectPathHash == null) {
            JOptionPane.showMessageDialog(this, "Fehler beim Speichern der Baumzust\u00e4nde: Konnte Hash f\u00fcr den Pfad nicht generieren.", "Speicherfehler", 0);
            return;
        }
        List<String> startTreeExpandedPaths = this.getExpandedPaths(this.startTree);
        List<String> targetTreeExpandedPaths = this.getExpandedPaths(this.targetTree);
        this.prefs.put("startTreeExpandedPaths_" + projectPathHash, String.join((CharSequence)";", startTreeExpandedPaths));
        this.prefs.put("targetTreeExpandedPaths_" + projectPathHash, String.join((CharSequence)";", targetTreeExpandedPaths));
    }

    private void loadExpandedTreeStates(File directory) {
        if (directory == null) {
            return;
        }
        String projectPathHash = this.generateMd5Hash(directory.getAbsolutePath());
        if (projectPathHash == null) {
            System.err.println("Fehler beim Laden der Baumzust\u00e4nde: Konnte Hash f\u00fcr den Pfad nicht generieren.");
            return;
        }
        String startTreeSavedPaths = this.prefs.get("startTreeExpandedPaths_" + projectPathHash, "");
        ArrayList<String> startExpandedPathsList = new ArrayList<String>();
        if (!startTreeSavedPaths.isEmpty()) {
            startExpandedPathsList.addAll(Arrays.asList(startTreeSavedPaths.split(";")));
        }
        this.applyExpandedPaths(this.startTree, this.startTreeRoot, startExpandedPathsList);
        boolean anySpecificFilterActive = false;
        if (this.extensionCheckBoxes != null) {
            for (JCheckBox cb : this.extensionCheckBoxes) {
                if (cb.getText().equals("Alle Dateien") || !cb.isSelected()) continue;
                anySpecificFilterActive = true;
                break;
            }
        }
        if (!anySpecificFilterActive && (this.targetSearchField == null || this.targetSearchField.getText().trim().isEmpty())) {
            String targetTreeSavedPaths = this.prefs.get("targetTreeExpandedPaths_" + projectPathHash, "");
            ArrayList<String> targetExpandedPathsList = new ArrayList<String>();
            if (!targetTreeSavedPaths.isEmpty()) {
                targetExpandedPathsList.addAll(Arrays.asList(targetTreeSavedPaths.split(";")));
            }
            this.applyExpandedPaths(this.targetTree, this.targetTreeRoot, targetExpandedPathsList);
        }
    }

    private void applyExpandedPaths(JTree tree, DefaultMutableTreeNode root, List<String> expandedPathsList) {
        if (expandedPathsList.isEmpty()) {
            return;
        }
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            File file;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof File) || !(file = (File)userObject).isDirectory()) continue;
            try {
                if (!expandedPathsList.contains(file.getCanonicalPath())) continue;
                tree.expandPath(new TreePath(node.getPath()));
            }
            catch (IOException ex) {
                System.err.println("Fehler beim Vergleichen des kanonischen Pfads: " + ex.getMessage());
            }
        }
    }

    private void performSearch(JTree tree, DefaultMutableTreeNode rootNode, String searchTerm, List<String> baseUnfilteredPaths, boolean isHtmlTree) {
        this.populateTreeFilteredInternal(tree, rootNode, baseUnfilteredPaths, isHtmlTree, searchTerm);
    }

    private String generateMd5Hash(String inputString) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(inputString.getBytes());
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = messageDigest;
            int n = messageDigest.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++n2;
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("MD5-Algorithmus nicht gefunden: " + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(PathGeneratorApp::new);
    }
}

